/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.utils;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.commands.PasswordProtectLoginCommand;
import de.dustplanet.passwordprotect.commands.PasswordProtectPasswordCommand;
import de.dustplanet.passwordprotect.commands.PasswordProtectSetJailLocationCommand;
import de.dustplanet.passwordprotect.commands.PasswordProtectSetPasswordCommand;
import de.dustplanet.passwordprotect.jail.JailHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectUtilities {
    private static final int BUFFER_SIZE = 1024;
    private final PasswordProtect plugin;
    private final String[] commands = new String[]{"help", "rules", "motd"};
    private List<String> commandList = new ArrayList<String>();
    private String hashAlgorithm = "SHA-512";

    @SuppressFBWarnings(value={"CD_CIRCULAR_DEPENDENCY", "FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
    public PasswordProtectUtilities(PasswordProtect instance) {
        this.plugin = instance;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public void copy(String yml, File file) {
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             InputStream inputStream = this.plugin.getResource(yml);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to copy the default config!", e);
        }
    }

    @SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_PRINTSTACKTRACE"})
    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.options().header("For help please refer to https://dev.bukkit.org/projects/passwordprotect");
        config.addDefault("hash", (Object)"SHA-512");
        config.addDefault("disableJailArea", (Object)Boolean.FALSE);
        config.addDefault("opsRequirePassword", (Object)Boolean.TRUE);
        config.addDefault("cleanPassword", (Object)Boolean.FALSE);
        config.addDefault("password", (Object)"");
        config.addDefault("passwordClean", (Object)"");
        config.addDefault("autoUpdater", (Object)Boolean.TRUE);
        config.addDefault("prevent.movement", (Object)Boolean.TRUE);
        config.addDefault("prevent.interaction", (Object)Boolean.TRUE);
        config.addDefault("prevent.interactionMobs", (Object)Boolean.TRUE);
        config.addDefault("prevent.itemPickup", (Object)Boolean.TRUE);
        config.addDefault("prevent.itemDrop", (Object)Boolean.TRUE);
        config.addDefault("prevent.portal", (Object)Boolean.TRUE);
        config.addDefault("prevent.blockPlace", (Object)Boolean.TRUE);
        config.addDefault("prevent.blockBreak", (Object)Boolean.TRUE);
        config.addDefault("prevent.triggering", (Object)Boolean.TRUE);
        config.addDefault("prevent.attacks", (Object)Boolean.TRUE);
        config.addDefault("prevent.damage", (Object)Boolean.TRUE);
        config.addDefault("prevent.chat", (Object)Boolean.TRUE);
        config.addDefault("prevent.deathDrops", (Object)Boolean.TRUE);
        config.addDefault("prevent.flying", (Object)Boolean.TRUE);
        config.addDefault("wrongAttempts.kick", (Object)3);
        config.addDefault("wrongAttempts.ban", (Object)5);
        config.addDefault("wrongAttempts.banIP", (Object)Boolean.TRUE);
        config.addDefault("broadcast.kick", (Object)Boolean.TRUE);
        config.addDefault("broadcast.ban", (Object)Boolean.TRUE);
        config.addDefault("darkness", (Object)Boolean.TRUE);
        config.addDefault("slowness", (Object)Boolean.TRUE);
        config.addDefault("teleportBack", (Object)Boolean.TRUE);
        config.addDefault("loginMessage", (Object)Boolean.TRUE);
        config.addDefault("allowedCommands", Arrays.asList(this.commands));
        this.setCommandList(config.getStringList("allowedCommands"));
        this.hashAlgorithm = config.contains("hash") ? config.getString("hash") : config.getString("encryption");
        try {
            MessageDigest.getInstance(this.hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.RED + "PasswordProtect can't use this hash! FATAL!");
            this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Falling back to SHA-512!");
            this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Report this IMMEDIATELY!");
            this.hashAlgorithm = "SHA-512";
            config.set("hash", (Object)"SHA-512");
            e.printStackTrace();
        }
        config.options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    public void loadLocalization(FileConfiguration localization, File localizationFile) {
        localization.addDefault("permission_denied", (Object)"&4You don't have the permission to do this!");
        localization.addDefault("enter_password", (Object)"&eThis server is password-protected\n&eEnter the password with &a/login &4<password> &eto play");
        localization.addDefault("set_password", (Object)"&ePasswordProtect is enabled but no password has been set\n&eUse &a/setpassword &4<password> &eto set it");
        localization.addDefault("password_accepted", (Object)"&aServer password accepted, you can now play");
        localization.addDefault("attempts_left_kick", (Object)"&4Server password incorrect! &e%attempts &4attempts left until kick...");
        localization.addDefault("attempts_left_ban", (Object)"&4Server password incorrect! &e%attempts &4attempts left until ban...");
        localization.addDefault("kick_message", (Object)"&4Kicked by &ePasswordProtect &4for too many wrong attempts...");
        localization.addDefault("ban_message", (Object)"&4Banned by &ePasswordProtect &4for too many wrong attempts...");
        localization.addDefault("kick_broadcast", (Object)"&e%player &4kicked by &ePasswordProtect &4for too many wrong attempts...");
        localization.addDefault("ban_broadcast", (Object)"&e%player &4banned by &ePasswordProtect &4for too many wrong attempts...");
        localization.addDefault("radius_not_number", (Object)"&4The radius was not a number! Using standard (4) instead!");
        localization.addDefault("jail_set", (Object)"&aJail location set");
        localization.addDefault("password_set", (Object)"&aServer password set!");
        localization.addDefault("only_ingame", (Object)"&4The command can only be used ingame!");
        localization.addDefault("config_invalid", (Object)"&4It seems like this server config invalid. Please re-set the password!");
        localization.addDefault("only_hashed", (Object)"&4Server password is only stored hashed...");
        localization.addDefault("password_not_set", (Object)"&eServer password is not set. Use /setpassword <password>");
        localization.addDefault("password", (Object)"&eServer password is &4%password");
        localization.addDefault("set_jail_area", (Object)"&eYou can set the jail area by going somewhere and using &a/setjaillocation &4[radius]");
        localization.addDefault("already_logged_in", (Object)"&eYou are already logged in!");
        localization.addDefault("no_login_console", (Object)"&eThe console can't login into the server!");
        localization.options().copyDefaults(true);
        this.saveLocalization(localization, localizationFile);
    }

    private void saveLocalization(FileConfiguration localization, File localizationFile) {
        try {
            localization.save(localizationFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save the localization.yml", e);
        }
    }

    public void registerCommands(JailHelper jailHelper) {
        PluginCommand setJailLocationPassword;
        PluginCommand setPasswordCommand;
        PluginCommand passwordCommand;
        PluginCommand loginCommand = this.plugin.getCommand("login");
        if (loginCommand != null) {
            loginCommand.setExecutor((CommandExecutor)new PasswordProtectLoginCommand(this.plugin));
        }
        if ((passwordCommand = this.plugin.getCommand("password")) != null) {
            passwordCommand.setExecutor((CommandExecutor)new PasswordProtectPasswordCommand(this.plugin));
        }
        if ((setPasswordCommand = this.plugin.getCommand("setpassword")) != null) {
            setPasswordCommand.setExecutor((CommandExecutor)new PasswordProtectSetPasswordCommand(this.plugin));
        }
        if ((setJailLocationPassword = this.plugin.getCommand("setjaillocation")) != null) {
            setJailLocationPassword.setExecutor((CommandExecutor)new PasswordProtectSetJailLocationCommand(this.plugin, jailHelper));
        }
    }

    public void message(CommandSender sender, String message, String value) {
        PluginDescriptionFile pdfFile = this.plugin.getDescription();
        if (message == null) {
            sender.sendMessage(ChatColor.DARK_RED + "Somehow this message is not defined. Please check your localization.yml");
        } else {
            String valueToSend = value;
            if (value == null) {
                valueToSend = "";
            }
            String replacedMessage = message.replace("%attempts", valueToSend).replace("%password", valueToSend).replace("%version", pdfFile.getVersion());
            String[] messageToSend = ChatColor.translateAlternateColorCodes((char)'&', (String)replacedMessage).split("\n");
            if (sender != null) {
                sender.sendMessage(messageToSend);
            }
        }
    }

    public void setPassword(String password) {
        String hashedPassword = this.hash(password);
        this.plugin.getConfig().set("password", (Object)hashedPassword);
        if (this.plugin.getConfig().getBoolean("cleanPassword", false)) {
            this.plugin.getConfig().set("passwordClean", (Object)password);
        }
        this.plugin.saveConfig();
    }

    @Nullable
    public String getCleanPassword() {
        if (this.plugin.getConfig().getBoolean("cleanPassword", false)) {
            return this.plugin.getConfig().getString("passwordClean");
        }
        return null;
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getPassword() {
        return this.plugin.getConfig().getString("password");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean isPasswordSet() {
        return !this.plugin.getConfig().getString("password", "").isEmpty();
    }

    @Nullable
    public String hash(String password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.hashAlgorithm);
            messageDigest.update(password.getBytes(Charset.defaultCharset()));
            byte[] byteData = messageDigest.digest();
            return String.format("%0" + (byteData.length << 1) + "x", new BigInteger(1, byteData));
        }
        catch (NoSuchAlgorithmException e) {
            this.plugin.getServer().getLogger().log(Level.SEVERE, "The algorithm is NOT known: " + this.hashAlgorithm.replaceAll("[\r\n]", ""), e);
            return null;
        }
    }

    public void sendPasswordRequiredMessage(Player player) {
        if (this.plugin.getConfig().getBoolean("loginMessage", true)) {
            String messageLocalization = this.plugin.getLocalization().getString("enter_password");
            this.message((CommandSender)player, messageLocalization, null);
        }
    }

    public List<String> getCommandList() {
        return this.commandList;
    }

    public void setCommandList(List<String> commandList) {
        this.commandList = commandList;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }
}

